	subroutine SOURCE0(iout, idbg, Ne, Nn, Np, Ns, NnNd, ie, tc, Soe, &
			 vZ, rZ, cZ, lastZ, Son)
! calculate the independent source [A]{So} (time-independent)

	implicit none
	integer iout, idbg
	integer Ne, Nn, Np, Ns, NnNd		! array parameters
	integer lastZ
	real*8 tc				! global  arrays (compact values)
	integer ie(Ne,5)			! global connectivity array
	integer rZ(Nn+1)			! global  arrays (compact rows)
	integer cZ(NnNd)			! global  arrays (compact columns)
	real*8 vZ(NnNd)				! global  arrays (compact values)
	real*8 Soe(Ne,Ns,4)			! element independent source nodal values
	real*8 Son(Nn,Ns)			! global  arrays

	integer e, m, ii, jj, s
	real*8 aa, src, Sn(Nn,Ns)

!	write(idbg,'(a)') ' --- SOURCE0 ---'	! ### TEMPORARY ###

! reset Son to 0
	Son = 0.		! use matrix form

! store the element So values in the nodal temporary Sn array
	do e = 1,Ne
	  do m = 1,4
	    do s = 1,Ns
	      Sn(ie(e, m),s) = Soe(e,s,m)
	    enddo	! s
	  enddo		! m
	enddo		! e

	do jj = 1, Nn
	  do ii = 1, Nn
	    aa = 0.
! access rank 2 sparse arrays
	    call ACCESS2(iout, idbg, Nn, NnNd, rZ, cZ, ii, jj, lastZ, m)

	    if (m .ne. 0)	then
	      aa = vZ(m)			! retrieve Z, the original A
	      if (Np .ne. 0)	then
	      endif
	    endif

	    do s = 1,Ns
	      src = aa*Sn(jj,s)
	      Son(ii,s) = Son(ii,s) - src	! -[A]{S}
	    enddo	! s
	  enddo		! ii
	enddo		! jj

	return
	end
